function [t_load,load,time_weather,irr_v,temp_v,n_days] = load_and_weather(first_day,last_day,pause_weight)


first_day = day( datetime(first_day, 'InputFormat', 'dd-MMM' ), 'dayofyear' );
last_day = day( datetime(last_day, 'InputFormat', 'dd-MMM' ), 'dayofyear' );

n_days = last_day-first_day + 1;

Table = readtable('Year_data_hourly.xlsx','Sheet','Sheet1','VariableNamingRule','preserve');

%% TIME AND WEATHER

time_weather = (0:1:n_days*24)';
irr_v = Table{(first_day-1)*24+1:last_day*24+1,"Irradiance [W/m^2]"};
temp_v = Table{(first_day-1)*24+1:last_day*24+1,"Temperature [°C]"};

%% TIME AND LOADS

t_ultra_short = [0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.249 0.25]';
ultra_short_slow = [0 3 3 3 3 3 3 3 3 0]';
ultra_short_fast = [0 5 5 5 5 5 5 5 5 0]';

t_short = [0 0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.49 0.5]';
short_slow = [0 3 3 3 3 3 3 3 3 0]';
short_fast = [0 5 5 5 5 5 5 5 5 0]';

t_medium = [0 0.01 0.02 0.03 0.04 0.05 0.249 0.25 0.749 0.75]';
medium_slow = [0 3.5 3.5 3.5 3.5 3.5 3.5 3 3 0]';
medium_fast = [0 5 5 5 5 5 5 4 4 0]';

t_long = [0 0.01 0.249 0.25 0.49 0.5 0.749 0.75 0.99 1]';
long_slow = [0 2 2 3 3 3 3 2 2 0]';
long_fast = [0 3 3 5 5 5 5 3 3 0]';

A_load_time = [t_ultra_short t_ultra_short t_short t_short t_medium t_medium t_long t_long];

A_load = [ultra_short_slow ultra_short_fast  short_slow short_fast...
            medium_slow medium_fast long_slow long_fast];


%% BUILD

pd_load = makedist('Multinomial','Probabilities',[0.175 0.175 0.175 0.175 0.1 0.1 0.05 0.05] );
pd_pause = makedist('Multinomial','Probabilities',[0.3 0.3 0.2 0.2]);

%Build load vector

t_load = zeros(1000*n_days,1);
load = zeros(1000*n_days,1);
t_load(1) = 0;
t_load(2) = 7;

ii = 2;

for zz =1:n_days

    while t_load(ii) < 24*zz

        flag_pause =  randi([0, 1], [1, 1]);

        if (t_load(ii)>=7+(zz-1)*24 && t_load(ii)<=21+(zz-1)*24 && flag_pause==0)

            r=random(pd_pause,1,1);
            t_load(ii+1) = t_load(ii)+0.25*r*pause_weight;
            ii = ii+1;

        elseif (t_load(ii)>=7+(zz-1)*24 && t_load(ii)<=21+(zz-1)*24 && flag_pause==1)

            r_l=random(pd_load,1,1);
            t_moment = t_load(ii);

            for jj=1:10

                t_load(ii) = t_moment + A_load_time(jj,r_l);
                load(ii) = A_load(jj,r_l);

                if  jj < 10
                    ii = ii+1;
                end

            end

            t_load(ii+1) = t_load(ii)+0.25*pause_weight;
            ii = ii+1;

        else

            t_load(ii+1) = 7+24*zz;
            ii = ii+1;

            if t_load(ii) > n_days*24
                t_load(ii)=n_days*24;
            end

        end

    end

end

t_load = t_load(1:ii);
load = load(1:ii);


end